/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.servlet.util.WCLLoggerServiceability;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.psw.uil.ras.IUilServiceability;
import com.ibm.psw.wcl.core.ClassLoaderUtil;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.page.IPageManager;
import com.ibm.psw.wcl.core.page.PageManager;
import com.ibm.psw.wcl.core.renderer.DefaultRendererFactory;
import com.ibm.psw.wcl.core.renderer.IRendererFactory;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.resource.IResourceLoaderManager;
import com.ibm.psw.wcl.core.resource.ResourceLoaderManager;
import com.ibm.psw.wcl.core.skin.DefaultSkinManager;
import com.ibm.psw.wcl.core.skin.ISkinManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.servlet.ServletContext;

public class WCLUtil {
    private static final String TRACE_MASKT = "XWCLUTLT";
    private static final String TRACE_MASKF = "XWCLUTLF";
    private static WCLUtil wclUtil;
    private static final String RENDERER_FACTORY_ID = "hmc.wclutil.renderFactory";
    private static final String SKIN_MANAGER_ID = "hmc.wclutil.skinManager";
    private static final String RESOURCE_LOADER_MANAGER_ID = "hmc.wclutil.resourceLoaderManager";
    private static final String PAGE_MANAGER_ID = "hmc.wclutil.pageManager";
    private static final String SERVICEABILITY_INTERFACE_ID = "hmc.wclutil.serviceabilityInterface";
    private static final String HMC_SKIN = "com/ibm/hwmca/fw/servlet/util/HMCskin.xml";
    private IRendererFactory rendererFactory;
    private ISkinManager skinManager;
    private IResourceLoaderManager resourceLoaderManager;
    private IPageManager pageManager;
    private IUilServiceability serviceabilityInterface;

    private WCLUtil() {
    }

    private synchronized void createWclObjects(ServletContext servletContext) throws HException {
        if (this.rendererFactory != null) {
            return;
        }
        String[] customRendererDefinitions = this.getCustomRendererDefinitions();
        Trace.trace(TRACE_MASKF, "Creating heavyweight WCL objects");
        long beforeTime = System.currentTimeMillis();
        try {
            this.rendererFactory = new DefaultRendererFactory(customRendererDefinitions);
        }
        catch (RendererException e) {
            Trace.trace(TRACE_MASKT, "Error creating global DefaultRendererFactory.");
            if (e instanceof RendererException.EMultipleErrors) {
                Trace.trace(TRACE_MASKT, "Multiple errors recognized:");
                RendererException.EMultipleErrors me = (RendererException.EMultipleErrors)e;
                int count = me.getMessageCount();
                for (int i = 0; i < count; ++i) {
                    Trace.trace(TRACE_MASKT, me.getMessage(i));
                }
            }
            Trace.trace(TRACE_MASKT, (Object)e);
            if (e.getException() != null) {
                Trace.trace(TRACE_MASKT, "The RendererException wrapped this exception");
                Trace.trace(TRACE_MASKT, e.getException());
            }
            throw new HException(e);
        }
        servletContext.setAttribute(RENDERER_FACTORY_ID, (Object)this.rendererFactory);
        this.resourceLoaderManager = new ResourceLoaderManager("/wclres");
        servletContext.setAttribute(RESOURCE_LOADER_MANAGER_ID, (Object)this.resourceLoaderManager);
        try {
            this.skinManager = new DefaultSkinManager(false);
            ((DefaultSkinManager)this.skinManager).loadSkins(ClassLoaderUtil.getResource((String)HMC_SKIN), RESOURCE_LOADER_MANAGER_ID, "");
        }
        catch (Exception ex) {
            Trace.trace(TRACE_MASKT, "DefaultSkinManager: Error occurred trying to get URL for given resource = com/ibm/hwmca/fw/servlet/util/HMCskin.xml('" + ex.getMessage() + "')");
            Trace.trace(TRACE_MASKT, ex);
            this.skinManager = null;
        }
        if (this.skinManager == null) {
            this.skinManager = new DefaultSkinManager();
        }
        servletContext.setAttribute(SKIN_MANAGER_ID, (Object)this.skinManager);
        this.pageManager = new PageManager("a", false, false);
        servletContext.setAttribute(PAGE_MANAGER_ID, (Object)this.pageManager);
        if (ServletRuntime.getRuntime().getServletOptions().getBoolean("wcl.servicability", false)) {
            this.serviceabilityInterface = new WCLLoggerServiceability(true);
            servletContext.setAttribute(SERVICEABILITY_INTERFACE_ID, (Object)this.serviceabilityInterface);
        }
        long elapsed = System.currentTimeMillis() - beforeTime;
        Trace.trace(TRACE_MASKT, "Elapsed time to create heavyweight WCL objects: " + elapsed + "ms");
    }

    public static synchronized WCLUtil getWCLUtil() {
        if (wclUtil == null) {
            wclUtil = new WCLUtil();
        }
        return wclUtil;
    }

    public WclFacade createFacade(String path, ServletContext servletContext) throws HException {
        this.createWclObjects(servletContext);
        return new WclFacade(path, null, null, "a", RENDERER_FACTORY_ID, "a", SKIN_MANAGER_ID, "a", RESOURCE_LOADER_MANAGER_ID, "a", PAGE_MANAGER_ID, null, null, this.serviceabilityInterface != null ? "a" : null, this.serviceabilityInterface != null ? SERVICEABILITY_INTERFACE_ID : null);
    }

    public void initializeInBackground(final ServletContext servletContext) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    WCLUtil.this.createWclObjects(servletContext);
                }
                catch (HException hException) {
                    // empty catch block
                }
            }
        }, "WCL Heavyweight Object Initialization");
        thread.setDaemon(true);
        thread.start();
    }

    private String[] getCustomRendererDefinitions() throws HException {
        InputStream defns = this.getClass().getResourceAsStream("wclCustomRenderer.definitions");
        if (defns == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(defns));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            try {
                in.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
            throw new HException("Error reading wclCustomRenderer.definitions: " + e.getMessage());
        }
        String[] result = new String[lines.size()];
        lines.toArray(result);
        return result;
    }
}

